/* This file is called in the header.php */

/* This function makes that videos are only played when they are visible but not on iOS because there the videos are player forever in fullscreen */
function autoplay_videos_when_visible()
{ 
	/* Avoid a bug in Safari which plays the videos forever on IOS in fullscreen */
	if (!(navigator.userAgent.match(/(iPod|iPhone|iPad)/))) {
	
		var videos = document.getElementsByTagName("video"),
		fraction = 0.8;
		function checkScroll() {

			for(var i = 0; i < videos.length; i++) {

				var video = videos[i];

				var x = video.offsetLeft, y = video.offsetTop, w = video.offsetWidth, h = video.offsetHeight, r = x + w, //right
					b = y + h, //bottom
					visibleX, visibleY, visible;

					visibleX = Math.max(0, Math.min(w, window.pageXOffset + window.innerWidth - x, r - window.pageXOffset));
					visibleY = Math.max(0, Math.min(h, window.pageYOffset + window.innerHeight - y, b - window.pageYOffset));

					visible = visibleX * visibleY / (w * h);

					if (visible > fraction) {
						video.play();
					} else {
						video.pause();
					}
			}
		}
	}
	
	window.addEventListener('scroll', checkScroll, false);
	window.addEventListener('resize', checkScroll, false);
}